/*
 * Decompiled with CFR 0.152.
 */
package craftedMods.lotr.recipes.internal.recipeHandlers;

import craftedMods.recipes.api.EnumRecipeItemRole;
import craftedMods.recipes.api.RecipeHandler;
import craftedMods.recipes.api.RecipeHandlerRecipeViewer;
import craftedMods.recipes.api.RecipeHandlerRenderer;
import craftedMods.recipes.api.RecipeItemSlot;
import craftedMods.recipes.api.RegisteredHandler;
import craftedMods.recipes.api.utils.RecipeHandlerRendererUtils;
import craftedMods.recipes.base.AbstractRecipeHandler;
import craftedMods.recipes.base.AbstractRecipeViewer;
import craftedMods.recipes.base.ShapelessRecipe;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import lotr.common.LOTRMod;
import lotr.common.recipe.LOTREntJarRecipes;
import net.minecraft.client.gui.inventory.GuiContainer;

@RegisteredHandler
public class EntJarRecipeHandler
extends AbstractRecipeHandler<ShapelessRecipe> {
    private final EntJarRecipeHandlerRenderer renderer = new EntJarRecipeHandlerRenderer();
    private final EntJarRecipeHandlerRecipeViewer recipeViewer = new EntJarRecipeHandlerRecipeViewer(this);

    public EntJarRecipeHandler() {
        super("lotr.entJar");
    }

    public String getDisplayName() {
        return LOTRMod.entJar.func_149732_F();
    }

    public Collection<ShapelessRecipe> loadSimpleStaticRecipes() {
        ArrayList<ShapelessRecipe> ret = new ArrayList<ShapelessRecipe>();
        try {
            Field entJarRecipesField = LOTREntJarRecipes.class.getDeclaredField("recipes");
            entJarRecipesField.setAccessible(true);
            Map recipes = (Map)entJarRecipesField.get(null);
            recipes.forEach((ingredient, result) -> ret.add(new ShapelessRecipe((Object)ingredient.func_77946_l(), result.func_77946_l())));
        }
        catch (Exception e) {
            this.logger.error("Couldn't access the field \"recipes\" in LOTREntJarRecipes.class", (Throwable)e);
        }
        return ret;
    }

    public List<RecipeItemSlot> getSlotsForRecipeItems(ShapelessRecipe recipe, EnumRecipeItemRole role) {
        return Arrays.asList(role == EnumRecipeItemRole.INGREDIENT ? this.createRecipeItemSlot(43, 24) : this.createRecipeItemSlot(101, 24));
    }

    public EntJarRecipeHandlerRenderer getRenderer() {
        return this.renderer;
    }

    public RecipeHandlerRecipeViewer<ShapelessRecipe> getRecipeViewer() {
        return this.recipeViewer;
    }

    public int getDefaultOrder() {
        return 6000;
    }

    public class EntJarRecipeHandlerRecipeViewer
    extends AbstractRecipeViewer<ShapelessRecipe, EntJarRecipeHandler> {
        public EntJarRecipeHandlerRecipeViewer(EntJarRecipeHandler handler) {
            super((RecipeHandler)handler);
        }

        public Collection<ShapelessRecipe> getAllRecipes() {
            return ((EntJarRecipeHandler)this.handler).getStaticRecipes();
        }

        public int getOffsetX(Class<? extends GuiContainer> guiClass) {
            return 8;
        }
    }

    public class EntJarRecipeHandlerRenderer
    implements RecipeHandlerRenderer<EntJarRecipeHandler, ShapelessRecipe> {
        public void renderBackground(EntJarRecipeHandler handler, ShapelessRecipe recipe, int cycleticks) {
            RecipeHandlerRendererUtils.getInstance().bindTexture("textures/gui/container/crafting_table.png");
            RecipeHandlerRendererUtils.getInstance().drawTexturedRectangle(42, 19, 65, 30, 80, 26);
            RecipeHandlerRendererUtils.getInstance().drawRectangle(42, 13, 18, 10, -3750202);
            RecipeHandlerRendererUtils.getInstance().drawRectangle(42, 41, 18, 4, -3750202);
        }

        public void renderForeground(EntJarRecipeHandler handler, ShapelessRecipe recipe, int cycleticks) {
        }
    }
}

